/***********************************************************************
* 
*      Filename                : FileLibrary.c
*      Module Name (s)         : bReadFileToArray()
* 
* Copyright (c) 2007 Texas Instruments, Inc.
* This is an unpublished work created in the year stated above.
* Texas Instruments owns all rights in and to this work and
* intends to maintain and protect it as an unpublished copyright.
* In the event of either inadvertent or deliberate publication,
* the above stated date shall be treated as the year of first
* publication.  In the event of such publication, Texas Instruments
* intends to enforce its rights in the work under the copyright
* laws as a published work.
* 
* These commodities are under U.S. Government 'distribution license'
* control.  As such they are not to be re-exported without prior
* approval from the U.S. Department of Commerce.
* 
* **********************************************************************
* 
* Author:              
*
* Revision History:    Rev 1.0  01.20.07  Original Version
* 
* **********************************************************************
* 
* Module Description:  Header file for File I/O type operations.
*
* **********************************************************************
*/
#include "stdafx.h"
#include "FileLibrary.h"
#include <math.h>

/* **********************************************************************
// FUNCTION : bReadFileToArray(...)
//
// DESCRIPTION :
// This function opens, reads and closes a file pointed by the sFile
// argument and places the contents of the ASCII file into the array
// cData.  The maximum array size is passed into the function as an
// argument.  The function then passes the actual size back to the calling
// function via the nMaxFileSize variables.
//
// Return Value     : BOOL                   TRUE  - Successful operation.
//                                           FALSE - Unsuccessful operation.
//
// Input Parameter  : CString sFile          Input string representing file
//                                           path
//
//                    int *nMaxFileSize      Number of Elements in Array
//                                           pointed to by cData
//
//                    char *cData            Array containing data to be
//                                           written to file sFile.
//
// Output Parameter : none
// **********************************************************************
*/
BOOL bReadFileToArray2(CString sFile, int *nMaxFileSize, char *cData)
{
  CString DebugText;
  int ch, i;
  int nRunningSize;
  FILE *file;
  i = 0;

  nRunningSize = 0;

  if((file = fopen(sFile, "rb")) == NULL)
  {
    // might want to check above flags- seems like they don't ever fail, even if they should
    DebugText.Format("Unable to open %s!! Check directory and permissions!!\n", sFile);
    AfxMessageBox(DebugText);
    return FALSE;
  }
  else
  {
//debugging 7/13
      printf("\n") ;
      printf("File open = %s\n",sFile) ;

	i=0;
	 // the file's open- let's read it into the public array so the dialog can edit it
    while((ch = getc(file)) != EOF && i < *nMaxFileSize)
    {
      *(cData +i) = ch ;
      i++;
      nRunningSize++;
    }
  }

  // so at this point, the array is updated, so let's close the file and let the dialog box just update the array
  fclose(file);
  *nMaxFileSize = nRunningSize;  // update the argument passed in as the real file size
  return TRUE;
}





BOOL bReadFileToArray(CString sCMDFile, int *nMaxFileSize, char *cData)
{
  CString DebugText, sFile;
  char	cFileName[100];
  int ch, i;
  int nRunningSize;
  FILE *file;
  i = 0;

  nRunningSize = 0;

  if((file = fopen(sCMDFile, "rb")) == NULL)
  {
    // might want to check above flags- seems like they don't ever fail, even if they should
    DebugText.Format("Unable to open %s!! Check directory and permissions!!\n", sFile);
    AfxMessageBox(DebugText);
    return FALSE;
  }
  else
  {
    while((ch = getc(file)) != EOF && i < *nMaxFileSize)
    {
      *(cFileName +i) = ch ;
      i++;
      nRunningSize++;
    }

  }
	sFile = cFileName;
	sFile = sFile.Left(sFile.Find('.')+4);

	sFile = sCMDFile.Left(sCMDFile.ReverseFind('\\')+1)+sFile;	//assemble input file name
//  if((file = fopen(sFile, "rb")) == NULL)
  if((file = fopen(sFile, "rb")) == NULL)
  {
    // might want to check above flags- seems like they don't ever fail, even if they should
    DebugText.Format("Unable to open %s!! Check directory and permissions!!\n", sFile);
    AfxMessageBox(DebugText);
    return FALSE;
  }
  else
  {
	i=0;
	 // the file's open- let's read it into the public array so the dialog can edit it
    while((ch = getc(file)) != EOF && i < *nMaxFileSize)
    {
      *(cData +i) = ch ;
      i++;
      nRunningSize++;
    }
  }

  // so at this point, the array is updated, so let's close the file and let the dialog box just update the array
  fclose(file);
  *nMaxFileSize = nRunningSize;  // update the argument passed in as the real file size
  return TRUE;
}





/* **********************************************************************
// FUNCTION : SortBlockAddrArray(...)
//
// DESCRIPTION :
// This function sorts an array of longs representing block load addresses.
// The original array is updated.
//
// Return Value     : none
//
// Input Parameter  : char *nBlockAddr      Array containing data to be
//                                          modified
//					: int *nBlockCount		Number of array elements
//
// Output Parameter : none
// **********************************************************************
*/

BOOL SortBlockAddrArray(long *nBlockAddr, int *nBlockCount)
{

	int	i, j, temp;
	*(nBlockAddr+*nBlockCount) = 0xFFFFFFFF;

	for(i=0; i<(*nBlockCount-1); i++)
		for(j=0; j<(*nBlockCount-1); j++)
		{
			if( (*(nBlockAddr+j))>(*(nBlockAddr+j+1)) )
			{
				temp = *(nBlockAddr+j);
				*(nBlockAddr+j) = *(nBlockAddr+j+1);
				*(nBlockAddr+j+1) = temp;
			}
		}

	return	TRUE;
}


/* **********************************************************************
// FUNCTION : SortBlockDataRecords(...)
//
// DESCRIPTION :
// This function moves the data blocks into ascending order using each 
// load address as the criteria for the sort.
//
// Return Value     : none
//
// Input Parameter  : int	*nMaxFileSize	Array length	
//					: char	*cData          Array containing data to be
//                                          modified
//					: long	*nBlockAddr		Array of sorted block load
//											addresses
//					: int	*nBlockCount	Number of blocks
//
// Output Parameter : none
// **********************************************************************
*/

	char    cDataBuffer[MAXFILESIZE] ;

BOOL SortBlockDataRecords(int *nMaxFileSize, char *cData, long *nBlockAddr, int *nBlockCount)
{
	int		i, j, nCurrentFilePos, len1, nMatchCount;
	char	*pBuffer;
	unsigned long	l1, l2, l3, l4;
	BOOL	match;

	pBuffer = cDataBuffer;

	//copy header
	for(i=0 ; i<28 ; i++)
		*pBuffer++ = cData[i];
	
	for(nMatchCount=0; nMatchCount<*nBlockCount; nMatchCount++)
	{

		match = 0;
		nCurrentFilePos = 22;
		i=0;
		while( (i++<*nBlockCount) && !match )
		{

			l1 = (*(cData+nCurrentFilePos+2)*(int)pow(16,4)) & 0x0FF0000;	//MSB of 22-bit addr
			l2 = (*(cData+nCurrentFilePos+5)*(int)pow(16,2)) & 0x0FF00;
			l3 = *(cData+nCurrentFilePos+4) & 0x0FF;						//LSB of 22-bit addr
			l4 = l1+l2+l3;				

			l1 = (*(cData+nCurrentFilePos+1)*(int)pow(16,2)) & 0x0FF00;		//MSB of 16-bit length
			l2 = *(cData+nCurrentFilePos) & 0x0FF;
			len1 = (l1+l2)*2;									//# of bytes

			if(l4 == *(nBlockAddr+nMatchCount))
			{	//copy data block only, w/o len & load addr
				match = 1;
				nCurrentFilePos+=BLOCKHEADER;								//pt to 1st data byte
				for(j=0; j<len1; j++)
					*pBuffer++  = *(cData+nCurrentFilePos++);
			}
			else
				nCurrentFilePos += (len1+BLOCKHEADER);

		}

	}

	//Update original data table
	*nMaxFileSize -= (*nBlockCount-1)*BLOCKHEADER;	//account removal of block headers
	for(i=0 ; i<(*nMaxFileSize-2) ; i++)
		cData[i] = cDataBuffer[i];

	cData[i++] = 0;
	cData[i] = 0;

	return	TRUE;
}

/* **********************************************************************
// FUNCTION : RemoveExtraInfo(...)
//
// DESCRIPTION :
// This function removes extra header information
//
// Return Value     : none
//
// Input Parameter  : int	*nMaxFileSize	Array length	
//					: char	*cData          Array containing data to be
//                                          modified
//					: long	*nBlockAddr		Array of sorted block load
//											addresses
//					: int	*nBlockCount	Number of blocks
//
// Output Parameter : none
// **********************************************************************
*/

BOOL RemoveExtraInfo(int *nMaxFileSize,char *cData, long *nBlockAddr, int *nBlockCount)
{


	return	TRUE;
}

/* **********************************************************************
// FUNCTION : BuildBlockAddrArray(...)
//
// DESCRIPTION :
// This function creates an unsorted array of block load addresses
//
// Return Value     : none
//
// Input Parameter  : int	*nMaxFileSize	Array length	
//					: char	*cData          Array containing block data 
//					: long	*nBlockAddr		Array of block load
//											addresses
//					: int	*nBlockCount	Number of blocks
//
// Output Parameter : none
// **********************************************************************
*/

BOOL BuildBlockAddrArray(int *nMaxFileSize,char *cData, long *nBlockAddr, int *nBlockCount)
{
	int		len1, nCurrentFilePos;
	unsigned long	l1, l2, l3, l4;
	long	*pBlockAddr;

	nCurrentFilePos = 22;
	*nBlockCount = 0;
	pBlockAddr = nBlockAddr;

	while(nCurrentFilePos < (*nMaxFileSize-2))
	{
		l1 = (*(cData+nCurrentFilePos+2)*(int)pow(16,4)) & 0x0FF0000;	//MSB of 22-bit addr
		l2 = (*(cData+nCurrentFilePos+5)*(int)pow(16,2)) & 0x0FF00;
		l3 = *(cData+nCurrentFilePos+4) & 0x0FF;					//LSB of 22-bit addr
		l4 = l1+l2+l3;				
		*pBlockAddr++ = l4;
		*nBlockCount += 1;

		l1 = (*(cData+nCurrentFilePos+1)*(int)pow(16,2)) & 0x0FF00;		//MSB of 16-bit length
		l2 = *(cData+nCurrentFilePos) & 0x0FF;
		len1 = (l1+l2)*2;									//# of bytes
		nCurrentFilePos += (len1+BLOCKHEADER);
	}

	return TRUE;
}

/* **********************************************************************
// FUNCTION : IntelHEXtoASCII(...)
//
// DESCRIPTION :
// This function takes a string array input in Intel format aand converts
// it to standard ASCII
//
// Return Value     : none
//
// Input Parameter  : char *cData            Array containing data to be
//                                           modified
//
// Output Parameter : char *cData
// **********************************************************************
*/

BOOL IntelHEXtoBinary(int *nMaxFileSize,char *cData)
{
	CString	s1, s2, s3, s4, s5, RecordType;
	int		nRowChars, t1, i=0, flag=0, bNum, nRunningSize;
	char	*OrigPtr;
	size_t	len, iLen;

	OrigPtr = cData;

	while(!flag)
	{
		i++;
		if(*cData == ':')
		{
			s1 = cData;

			nRowChars = 2*HexStringToInt(s1.Mid(1,2));
			RecordType = s1.Mid(8,1);

			if(RecordType == "1")				//EOF record
			{
				s4 += "/0";
				flag =1;
			}
			else if(RecordType == "4")		//Extended linear address record
			{	
				t1 = 17;
				cData += t1;
			}
			else
			{	
				s4 += s1.Mid(9,nRowChars);	//Data record
				t1 = (9 + nRowChars + 2 + 2);
				cData += t1;
			}
			
		}
		else
		{
			AfxMessageBox("IntelHEXtoBinary function failed, index out-of-sync");
			return FALSE;
		}
	
	}
	lstrcpy( OrigPtr, s4 );

	len = strlen( OrigPtr);
	nRunningSize=0;

	for(iLen=0 ; iLen<len ; iLen+=2)
	{
		s3 = s4.Mid(iLen,2);
		bNum = HexStringToInt(s3);
		*(OrigPtr+nRunningSize) = bNum;
		nRunningSize++;
	}

  *nMaxFileSize = nRunningSize-1;  // update the argument passed in as the real file size

	return TRUE;
}
/* **********************************************************************
// FUNCTION : MotHEXtoASCII(...)
//
// DESCRIPTION :
// This function takes a string array input in Mot format aand converts
// it to standard ASCII
//
// Return Value     : none
//
// Input Parameter  : char *cData            Array containing data to be
//                                           modified
//
// Output Parameter : char *cData
// **********************************************************************
*/

BOOL MotHEXtoBinary(int *nMaxFileSize,char *cData)
{
	CString	s1, s2, s3, s4, s5, RecordType;
	int		nRowChars, t1, i=0, flag=0, bNum, nRunningSize;
	char	*OrigPtr;
	size_t	len, iLen;

	OrigPtr = cData;

	while(!flag)
	{
		i++;
		if(*cData == 'S')
		{
			s1 = cData;
			nRowChars = 2*HexStringToInt(s1.Mid(2,2))-8;
			RecordType = s1.Mid(1,1);

			if(RecordType == "8")				//EOF record
			{
				s4 += "/0";
				flag =1;
			}
			else if(RecordType == "0")		//Header Record
			{	
				t1 = 18;
				cData += t1;
			}
			else
			{	
				s4 += s1.Mid(10,nRowChars);	//Data record
				t1 = (10+nRowChars + 2 + 2);
				cData += t1;
			}
			
		}
		else
		{
			AfxMessageBox("MotHEXtoBinary function failed, index out-of-sync");
			return FALSE;
		}
	
	}
	lstrcpy( OrigPtr, s4 );

	len = strlen( OrigPtr);
	nRunningSize=0;

	for(iLen=0 ; iLen<len ; iLen+=2)
	{
		s3 = s4.Mid(iLen,2);
		bNum = HexStringToInt(s3);
		*(OrigPtr+nRunningSize) = bNum;
		nRunningSize++;
	}

  *nMaxFileSize = nRunningSize-1;  // update the argument passed in as the real file size

	return TRUE;
}



BOOL SwapEndian(int *nMaxFileSize,char *cData)
{
	CString	s1, s2, s3, s4, s5, RecordType;
	int		nRowChars, t1, i=0, flag=0, nRunningSize, rowCnt=0;
	char	*OrigPtr;
	byte	bNum;
	size_t	len, iLen;

	OrigPtr = cData;

	len = *nMaxFileSize;
	nRunningSize=0;

	for(iLen=0 ; iLen<len ; iLen+=2)
	{
		bNum = *OrigPtr;
		*OrigPtr++ = *(OrigPtr+1);
		*OrigPtr++ = bNum;
	}
	return TRUE;

}
BOOL HEXtoBinary(int *nMaxFileSize,char *cData)
{
	CString	s1, s2, s3, s4, s5, RecordType;
	int		nRowChars, t1, i=0, flag=0, bNum, nRunningSize, rowCnt=0;
	char	*OrigPtr;
	size_t	len, iLen;

	OrigPtr = cData;

	while(!flag)
	{
		i++;
		if(*cData != 'S' && *cData != ':')
		{
			AfxMessageBox("MotHEXtoBinary function failed, index out-of-sync");
			return FALSE;
		}

		s1 = cData;

		if(*cData == ':')
		{	//Intel format
			nRowChars = 2*HexStringToInt(s1.Mid(1,2));
			RecordType = s1.Mid(8,1);
			if(RecordType == "1")				//EOF record
			{
				s4 += "/0";
				flag =1;
			}
			else if(RecordType == "4")		//Extended linear address record
			{	
				t1 = 17;
				cData += t1;
			}
			else
			{	
				rowCnt++;
				s4 += s1.Mid(9,nRowChars);	//Data record
				t1 = (9 + nRowChars + 2 + 2);
				cData += t1;
			}

		}
		else
		{	//Mot S-record Format
			nRowChars = 2*HexStringToInt(s1.Mid(2,2))-8; //# of data bytes	
			RecordType = s1.Mid(1,1);
			if(RecordType == "8")				//EOF record
			{
				s4 += "/0";
				flag =1;
			}
			else if(RecordType == "0")		//Header Record
			{	
				t1 = 18;
				cData += t1;
			}
			else
			{	
				rowCnt++;
				s4 += s1.Mid(10,nRowChars);	//Data record
				t1 = (10+nRowChars + 2 + 2);
				cData += t1;
				if(!*cData)
				{
					s4 += "/0";
					flag =1;
				}
			}
		}


	}	//end While

			
	lstrcpy( OrigPtr, s4 );

	len = strlen( OrigPtr);
	nRunningSize=0;

	for(iLen=0 ; iLen<len ; iLen+=2)
	{
		s3 = s4.Mid(iLen,2);
		bNum = HexStringToInt(s3);
		*(OrigPtr+nRunningSize) = bNum;
		nRunningSize++;
	}

  *nMaxFileSize = nRunningSize-1;  // update the argument passed in as the real file size

	return TRUE;
}

/* **********************************************************************
// FUNCTION : bWriteArrayToFile(...)
//
// DESCRIPTION :
// This function opens and closes a file pointed by the sFile
// argument and writes the contents of array cData into the ASCII file.
// The maximum array size is passed into the function as an
// argument.
//
// Return Value     : BOOL                   TRUE  - Successful operation.
//                                           FALSE - Unsuccessful operation.
//
// Input Parameter  : CString sFile          Input string representing file
//                                           path
//
//                    int *nMaxFileSize      Number of Elements in Array
//                                           pointed to by cData
//
//                    char *cData            Array containing data to be
//                                           written to file sFile.
//
// Output Parameter : none
// **********************************************************************
*/
BOOL bWriteArrayToFile(CString sFile, int *nMaxFileSize, char *cData)
{
  CString DebugText;
  int i;
  FILE *file;
  i = 0;

  if((file = fopen(sFile, "wb")) == NULL)
  {
    // might want to check above flags- seems like they don't ever fail, even if they should
    DebugText.Format("Unable to open %s for writing!! Check directory and permissions!!\n", sFile);
    AfxMessageBox(DebugText);
    return FALSE;
  }
  else
  {
    // you have the comm
    for(i=0; i<*nMaxFileSize; i++)
    {
      putc(cData[i], file);
    }
  }
  fclose(file);
  return TRUE;
}


/* **********************************************************************
// FUNCTION : HexStringToInt(...)
//
// DESCRIPTION :
// This function converts a string representation of a number to an actual
// integer.
//
// Return Value     : int value              Numerical value represented by
//                                           input string
//
// Input Parameter  : CString string         Input string
//
// Output Parameter : none
// **********************************************************************
*/
int HexStringToInt(CString sString)
{
  int i;
  int nLength;
  char cTargetChar;
  int nRunningTotal;

  nRunningTotal = 0;
  sString.MakeUpper();

  nLength = sString.GetLength();

  for(i = (nLength -1); i > -1; i--)
  {
    cTargetChar	= sString.GetAt(i);
    switch (cTargetChar)
    {
      case '0':
        nRunningTotal += 0;
        break;
      case '1':
        nRunningTotal += 1 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '2':
        nRunningTotal += 2 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '3':
        nRunningTotal += 3 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '4':
        nRunningTotal += 4 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '5':
        nRunningTotal += 5 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '6':
        nRunningTotal += 6 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '7':
        nRunningTotal += 7 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '8':
        nRunningTotal += 8 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case '9':
        nRunningTotal += 9 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'A':
        nRunningTotal += 10 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'B':
        nRunningTotal += 11 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'C':
        nRunningTotal += 12 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'D':
        nRunningTotal += 13 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'E':
        nRunningTotal += 14 * (int)(pow(16, ((nLength -1) - i)));
        break;
      case 'F':
        nRunningTotal += 15 * (int)(pow(16, ((nLength -1) - i)));
        break;
      default:
        nRunningTotal += 0;
        break;
    }
  }
  return nRunningTotal;
}
